
# This file was generated by the SOM Compiler.
# FileName: somcm.sc.
# Generated using:
#     SOM Precompiler spc: 1.22
#     SOM Emitter emitcsc: 1.10

--  SOMClassMgr: System Object Model class manager
--  Copyright (c) International Business Machines Corporation
-- 		 1991, 1992

#include <somobj.sc>

class: SOMClassMgr, 
    external stem = somcm, function prefix = somm_, major version = 1, 
    minor version = 1, file stem = somcm;


parent class: SOMObject;


release order:
    somFindClsInFile, somFindClass, somClassFromId, 
    somRegisterClass, somUnregisterClass, somLocateClassFile, 
    somLoadClassFile, somUnloadClassFile, somGetInitFunction, 
    somMergeInto, somGetRelatedClasses;

methods:
group: Basic;

    SOMClass *   somLoadClassFile(INOUT somId classId,
		IN integer4 majorVersion,
		IN integer4 minorVersion,
		IN zString file);

    --  Loads the class' code and initializes the class object.

    zString    somLocateClassFile(INOUT somId classId,
		IN integer4 majorVersion,
		IN integer4 minorVersion);

    --  Real implementation supplied by subclasses.  Default implementation
    --  returns the class name as the file name.   Subclasses may use
    --  version number info to assist in deriving the file name.

    void    somRegisterClass(IN SOMClass *classObj);

    --  Lets the class manager know that the specified class is installed
    --  and tells it where the class object is.

    int    somUnloadClassFile(IN SOMClass *classObj);

    --  Releases the class' code and unregisters all classes in the
    --  same affinity group (see somGetRelatedClasses below).

    int    somUnregisterClass(IN SOMClass *classObj);

    --  Free the class object and removes the class from the SOM registry.
    --  If the class caused dynamic loading to occur, it is also unloaded
    --  (causing its entire affinity group to be unregistered as well).

group: Access;

    zString    somGetInitFunction();

    --  Supplies the name of the initialization function in the class' code
    --  file.  Default implementation returns (*SOMClassInitFuncName)().

    SOMClass **   somGetRelatedClasses(IN SOMClass *classObj);

    --  Returns an array of class objects that were all registered during
    --  the dynamic loading of a class.	These classes are considered to
    --  define an affinity group.  Any class is a member of at most one
    --  affinity group.	The affinity group returned by this call is the
    --  one containing the class identified by classObj.  The first element
    --  in the array is the class that caused the group to be loaded, or the
    --  special value -1 which means that the SOMClassMgr is currently in the
    --  process of unregistering and deleting the affinity group (only
    --  SOMClassMgr subclasses would ever see this value).
    --  The remainder of the array (elements one thru n) consists of
    --  pointers to class objects ordered in reverse chronological sequence
    --  to that in which they were originally registered.  This list includes
    --  the given argument, classObj, as one of its elements, as well as the
    --  class, if any, returned as element[0] above.  The array is terminated
    --  by a NULL pointer as the last element.  Use SOMFree to release the
    --  array when it is no longer needed.  If the supplied class was not
    --  dynamically loaded, it is not a member of any affinity
    --  group and NULL is returned.

group: Dynamic;

    SOMClass *   somClassFromId(IN somId classId);

    --  Finds the class object, given its Id, if it already exists.
    --  Does not load the class.  Returns NULL if the class object does
    --  not yet exist.

    SOMClass *   somFindClass(INOUT somId classId,
		IN integer4 majorVersion,
		IN integer4 minorVersion);

    --  Returns the class object for the specified class.  This may result
    --  in dynamic loading.  Uses somLocateClassFile to obtain the name of
    --  the file where the class' code resides, then uses somFindClsInFile.

    SOMClass *   somFindClsInFile(INOUT somId classId,
		IN integer4 majorVersion,
		IN integer4 minorVersion,
		IN zString file);

    --  Returns the class object for the specified class.  This may result
    --  in dynamic loading.  If the class already exists <file> is ignored,
    --  otherwise it is used to locate and dynamically load the class.
    --  Values of 0 for major and minor version numbers bypass version checking.

    void    somMergeInto(IN SOMObject *targetObj);

    --  Merges the SOMClassMgr registry information from the receiver to
    --  <targetObj>.  <targetObj> is required to be an instance of SOMClassMgr
    --  or one of its subclasses.  At the completion of this operation,
    --  the <targetObj> should be able to function as a replacement for the
    --  receiver.  At the end of the operation the receiver object (which is
    --  then in a newly uninitialized state) is freed.  Subclasses that
    --  override this method should similarly transfer their sections of
    --  the object and pass this method to their parent as the final step.
    --  If the receiving object is the distinguished instance pointed to
    --  from the global variable SOMClassMgrObject, SOMCLassMgrObject is
    --  then reassigned to point to <targetObj>.

    override somInit;

    -- From SOMObject

    override somUninit;

    -- From SOMObject

    override somDumpSelfInt;

    -- From SOMObject

